package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  AppName,
  UserProfileName,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class AppDetails(
    domainId: Option[DomainId] = None,
    userProfileName: Option[UserProfileName] = None,
    appType: Option[zio.aws.sagemaker.model.AppType] = None,
    appName: Option[AppName] = None,
    status: Option[zio.aws.sagemaker.model.AppStatus] = None,
    creationTime: Option[CreationTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AppDetails = {
    import AppDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AppDetails
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(appType.map(value => value.unwrap))(_.appType)
      .optionallyWith(
        appName.map(value => AppName.unwrap(value): java.lang.String)
      )(_.appName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AppDetails.ReadOnly =
    zio.aws.sagemaker.model.AppDetails.wrap(buildAwsValue())
}
object AppDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AppDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AppDetails =
      zio.aws.sagemaker.model.AppDetails(
        domainId.map(value => value),
        userProfileName.map(value => value),
        appType.map(value => value),
        appName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value)
      )
    def domainId: Option[DomainId]
    def userProfileName: Option[UserProfileName]
    def appType: Option[zio.aws.sagemaker.model.AppType]
    def appName: Option[AppName]
    def status: Option[zio.aws.sagemaker.model.AppStatus]
    def creationTime: Option[CreationTime]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getAppType: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppType] =
      AwsError.unwrapOptionField("appType", appType)
    def getAppName: ZIO[Any, AwsError, AppName] =
      AwsError.unwrapOptionField("appName", appName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AppDetails
  ) extends zio.aws.sagemaker.model.AppDetails.ReadOnly {
    override val domainId: Option[DomainId] = scala
      .Option(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileName: Option[UserProfileName] = scala
      .Option(impl.userProfileName())
      .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val appType: Option[zio.aws.sagemaker.model.AppType] = scala
      .Option(impl.appType())
      .map(value => zio.aws.sagemaker.model.AppType.wrap(value))
    override val appName: Option[AppName] = scala
      .Option(impl.appName())
      .map(value => zio.aws.sagemaker.model.primitives.AppName(value))
    override val status: Option[zio.aws.sagemaker.model.AppStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.AppStatus.wrap(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AppDetails
  ): zio.aws.sagemaker.model.AppDetails.ReadOnly = new Wrapper(impl)
}
