package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateWorkteamResponse(
    workteam: zio.aws.sagemaker.model.Workteam
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse = {
    import UpdateWorkteamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse
      .builder()
      .workteam(workteam.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateWorkteamResponse.wrap(buildAwsValue())
}
object UpdateWorkteamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateWorkteamResponse =
      zio.aws.sagemaker.model.UpdateWorkteamResponse(workteam.asEditable)
    def workteam: zio.aws.sagemaker.model.Workteam.ReadOnly
    def getWorkteam
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.Workteam.ReadOnly] =
      ZIO.succeed(workteam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse
  ) extends zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly {
    override val workteam: zio.aws.sagemaker.model.Workteam.ReadOnly =
      zio.aws.sagemaker.model.Workteam.wrap(impl.workteam())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse
  ): zio.aws.sagemaker.model.UpdateWorkteamResponse.ReadOnly = new Wrapper(impl)
}
