package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  TrialArn
}
import scala.jdk.CollectionConverters._
final case class TrialSummary(
    trialArn: Option[TrialArn] = None,
    trialName: Option[ExperimentEntityName] = None,
    displayName: Option[ExperimentEntityName] = None,
    trialSource: Option[zio.aws.sagemaker.model.TrialSource] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialSummary = {
    import TrialSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialSummary
      .builder()
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(trialSource.map(value => value.buildAwsValue()))(
        _.trialSource
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialSummary.wrap(buildAwsValue())
}
object TrialSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialSummary =
      zio.aws.sagemaker.model.TrialSummary(
        trialArn.map(value => value),
        trialName.map(value => value),
        displayName.map(value => value),
        trialSource.map(value => value.asEditable),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def trialArn: Option[TrialArn]
    def trialName: Option[ExperimentEntityName]
    def displayName: Option[ExperimentEntityName]
    def trialSource: Option[zio.aws.sagemaker.model.TrialSource.ReadOnly]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTrialSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      AwsError.unwrapOptionField("trialSource", trialSource)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ) extends zio.aws.sagemaker.model.TrialSummary.ReadOnly {
    override val trialArn: Option[TrialArn] = scala
      .Option(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
    override val trialName: Option[ExperimentEntityName] = scala
      .Option(impl.trialName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val trialSource
        : Option[zio.aws.sagemaker.model.TrialSource.ReadOnly] = scala
      .Option(impl.trialSource())
      .map(value => zio.aws.sagemaker.model.TrialSource.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ): zio.aws.sagemaker.model.TrialSummary.ReadOnly = new Wrapper(impl)
}
