package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  AutoGenerateEndpointName
}
import scala.jdk.CollectionConverters._
final case class ModelDeployConfig(
    autoGenerateEndpointName: Option[AutoGenerateEndpointName] = None,
    endpointName: Option[EndpointName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig = {
    import ModelDeployConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig
      .builder()
      .optionallyWith(
        autoGenerateEndpointName.map(value =>
          AutoGenerateEndpointName.unwrap(value): java.lang.Boolean
        )
      )(_.autoGenerateEndpointName)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelDeployConfig.wrap(buildAwsValue())
}
object ModelDeployConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDeployConfig =
      zio.aws.sagemaker.model.ModelDeployConfig(
        autoGenerateEndpointName.map(value => value),
        endpointName.map(value => value)
      )
    def autoGenerateEndpointName: Option[AutoGenerateEndpointName]
    def endpointName: Option[EndpointName]
    def getAutoGenerateEndpointName
        : ZIO[Any, AwsError, AutoGenerateEndpointName] = AwsError
      .unwrapOptionField("autoGenerateEndpointName", autoGenerateEndpointName)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig
  ) extends zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly {
    override val autoGenerateEndpointName: Option[AutoGenerateEndpointName] =
      scala
        .Option(impl.autoGenerateEndpointName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AutoGenerateEndpointName(value)
        )
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDeployConfig
  ): zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly = new Wrapper(impl)
}
