package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  StudioLifecycleConfigName,
  NextToken,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStudioLifecycleConfigsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    nameContains: Option[StudioLifecycleConfigName] = None,
    appTypeEquals: Option[
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = None,
    creationTimeBefore: Option[Timestamp] = None,
    creationTimeAfter: Option[Timestamp] = None,
    modifiedTimeBefore: Option[Timestamp] = None,
    modifiedTimeAfter: Option[Timestamp] = None,
    sortBy: Option[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest = {
    import ListStudioLifecycleConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        nameContains.map(value =>
          StudioLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(appTypeEquals.map(value => value.unwrap))(_.appTypeEquals)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        modifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeBefore)
      .optionallyWith(
        modifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeAfter)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest
      .wrap(buildAwsValue())
}
object ListStudioLifecycleConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest =
      zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        nameContains.map(value => value),
        appTypeEquals.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        modifiedTimeBefore.map(value => value),
        modifiedTimeAfter.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def nameContains: Option[StudioLifecycleConfigName]
    def appTypeEquals
        : Option[zio.aws.sagemaker.model.StudioLifecycleConfigAppType]
    def creationTimeBefore: Option[Timestamp]
    def creationTimeAfter: Option[Timestamp]
    def modifiedTimeBefore: Option[Timestamp]
    def modifiedTimeAfter: Option[Timestamp]
    def sortBy: Option[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNameContains: ZIO[Any, AwsError, StudioLifecycleConfigName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getAppTypeEquals: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = AwsError.unwrapOptionField("appTypeEquals", appTypeEquals)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeBefore", modifiedTimeBefore)
    def getModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeAfter", modifiedTimeAfter)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ) extends zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val nameContains: Option[StudioLifecycleConfigName] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName(value)
      )
    override val appTypeEquals
        : Option[zio.aws.sagemaker.model.StudioLifecycleConfigAppType] = scala
      .Option(impl.appTypeEquals())
      .map(value =>
        zio.aws.sagemaker.model.StudioLifecycleConfigAppType.wrap(value)
      )
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.modifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.modifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.StudioLifecycleConfigSortKey.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ): zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
