package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NumberOfHumanWorkersPerDataObject,
  AccountId,
  Timestamp,
  LabelingJobName,
  JobReferenceCode
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LabelingJobForWorkteamSummary(
    labelingJobName: Option[LabelingJobName] = None,
    jobReferenceCode: JobReferenceCode,
    workRequesterAccountId: AccountId,
    creationTime: Timestamp,
    labelCounters: Option[zio.aws.sagemaker.model.LabelCountersForWorkteam] =
      None,
    numberOfHumanWorkersPerDataObject: Option[
      NumberOfHumanWorkersPerDataObject
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary = {
    import LabelingJobForWorkteamSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary
      .builder()
      .optionallyWith(
        labelingJobName.map(value =>
          LabelingJobName.unwrap(value): java.lang.String
        )
      )(_.labelingJobName)
      .jobReferenceCode(
        JobReferenceCode.unwrap(jobReferenceCode): java.lang.String
      )
      .workRequesterAccountId(
        AccountId.unwrap(workRequesterAccountId): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(labelCounters.map(value => value.buildAwsValue()))(
        _.labelCounters
      )
      .optionallyWith(
        numberOfHumanWorkersPerDataObject.map(value =>
          NumberOfHumanWorkersPerDataObject.unwrap(value): Integer
        )
      )(_.numberOfHumanWorkersPerDataObject)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.wrap(buildAwsValue())
}
object LabelingJobForWorkteamSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobForWorkteamSummary =
      zio.aws.sagemaker.model.LabelingJobForWorkteamSummary(
        labelingJobName.map(value => value),
        jobReferenceCode,
        workRequesterAccountId,
        creationTime,
        labelCounters.map(value => value.asEditable),
        numberOfHumanWorkersPerDataObject.map(value => value)
      )
    def labelingJobName: Option[LabelingJobName]
    def jobReferenceCode: JobReferenceCode
    def workRequesterAccountId: AccountId
    def creationTime: Timestamp
    def labelCounters
        : Option[zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly]
    def numberOfHumanWorkersPerDataObject
        : Option[NumberOfHumanWorkersPerDataObject]
    def getLabelingJobName: ZIO[Any, AwsError, LabelingJobName] =
      AwsError.unwrapOptionField("labelingJobName", labelingJobName)
    def getJobReferenceCode: ZIO[Any, Nothing, JobReferenceCode] =
      ZIO.succeed(jobReferenceCode)
    def getWorkRequesterAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(workRequesterAccountId)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLabelCounters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly
    ] = AwsError.unwrapOptionField("labelCounters", labelCounters)
    def getNumberOfHumanWorkersPerDataObject
        : ZIO[Any, AwsError, NumberOfHumanWorkersPerDataObject] =
      AwsError.unwrapOptionField(
        "numberOfHumanWorkersPerDataObject",
        numberOfHumanWorkersPerDataObject
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary
  ) extends zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly {
    override val labelingJobName: Option[LabelingJobName] = scala
      .Option(impl.labelingJobName())
      .map(value => zio.aws.sagemaker.model.primitives.LabelingJobName(value))
    override val jobReferenceCode: JobReferenceCode =
      zio.aws.sagemaker.model.primitives
        .JobReferenceCode(impl.jobReferenceCode())
    override val workRequesterAccountId: AccountId =
      zio.aws.sagemaker.model.primitives
        .AccountId(impl.workRequesterAccountId())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val labelCounters
        : Option[zio.aws.sagemaker.model.LabelCountersForWorkteam.ReadOnly] =
      scala
        .Option(impl.labelCounters())
        .map(value =>
          zio.aws.sagemaker.model.LabelCountersForWorkteam.wrap(value)
        )
    override val numberOfHumanWorkersPerDataObject
        : Option[NumberOfHumanWorkersPerDataObject] = scala
      .Option(impl.numberOfHumanWorkersPerDataObject())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NumberOfHumanWorkersPerDataObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary
  ): zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly =
    new Wrapper(impl)
}
