package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.LabelCounter
import scala.jdk.CollectionConverters._
final case class LabelCounters(
    totalLabeled: Option[LabelCounter] = None,
    humanLabeled: Option[LabelCounter] = None,
    machineLabeled: Option[LabelCounter] = None,
    failedNonRetryableError: Option[LabelCounter] = None,
    unlabeled: Option[LabelCounter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelCounters = {
    import LabelCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelCounters
      .builder()
      .optionallyWith(
        totalLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.totalLabeled)
      .optionallyWith(
        humanLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.humanLabeled)
      .optionallyWith(
        machineLabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.machineLabeled)
      .optionallyWith(
        failedNonRetryableError.map(value =>
          LabelCounter.unwrap(value): Integer
        )
      )(_.failedNonRetryableError)
      .optionallyWith(
        unlabeled.map(value => LabelCounter.unwrap(value): Integer)
      )(_.unlabeled)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelCounters.ReadOnly =
    zio.aws.sagemaker.model.LabelCounters.wrap(buildAwsValue())
}
object LabelCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelCounters =
      zio.aws.sagemaker.model.LabelCounters(
        totalLabeled.map(value => value),
        humanLabeled.map(value => value),
        machineLabeled.map(value => value),
        failedNonRetryableError.map(value => value),
        unlabeled.map(value => value)
      )
    def totalLabeled: Option[LabelCounter]
    def humanLabeled: Option[LabelCounter]
    def machineLabeled: Option[LabelCounter]
    def failedNonRetryableError: Option[LabelCounter]
    def unlabeled: Option[LabelCounter]
    def getTotalLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("totalLabeled", totalLabeled)
    def getHumanLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("humanLabeled", humanLabeled)
    def getMachineLabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("machineLabeled", machineLabeled)
    def getFailedNonRetryableError: ZIO[Any, AwsError, LabelCounter] = AwsError
      .unwrapOptionField("failedNonRetryableError", failedNonRetryableError)
    def getUnlabeled: ZIO[Any, AwsError, LabelCounter] =
      AwsError.unwrapOptionField("unlabeled", unlabeled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ) extends zio.aws.sagemaker.model.LabelCounters.ReadOnly {
    override val totalLabeled: Option[LabelCounter] = scala
      .Option(impl.totalLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val humanLabeled: Option[LabelCounter] = scala
      .Option(impl.humanLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val machineLabeled: Option[LabelCounter] = scala
      .Option(impl.machineLabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val failedNonRetryableError: Option[LabelCounter] = scala
      .Option(impl.failedNonRetryableError())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
    override val unlabeled: Option[LabelCounter] = scala
      .Option(impl.unlabeled())
      .map(value => zio.aws.sagemaker.model.primitives.LabelCounter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelCounters
  ): zio.aws.sagemaker.model.LabelCounters.ReadOnly = new Wrapper(impl)
}
