package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{KernelDisplayName, KernelName}
import scala.jdk.CollectionConverters._
final case class KernelSpec(
    name: KernelName,
    displayName: Option[KernelDisplayName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.KernelSpec = {
    import KernelSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.KernelSpec
      .builder()
      .name(KernelName.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          KernelDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.KernelSpec.ReadOnly =
    zio.aws.sagemaker.model.KernelSpec.wrap(buildAwsValue())
}
object KernelSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.KernelSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.KernelSpec =
      zio.aws.sagemaker.model.KernelSpec(name, displayName.map(value => value))
    def name: KernelName
    def displayName: Option[KernelDisplayName]
    def getName: ZIO[Any, Nothing, KernelName] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, KernelDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelSpec
  ) extends zio.aws.sagemaker.model.KernelSpec.ReadOnly {
    override val name: KernelName =
      zio.aws.sagemaker.model.primitives.KernelName(impl.name())
    override val displayName: Option[KernelDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.KernelDisplayName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelSpec
  ): zio.aws.sagemaker.model.KernelSpec.ReadOnly = new Wrapper(impl)
}
