package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DriftCheckExplainability(
    constraints: Option[zio.aws.sagemaker.model.MetricsSource] = None,
    configFile: Option[zio.aws.sagemaker.model.FileSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability = {
    import DriftCheckExplainability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
      .builder()
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(configFile.map(value => value.buildAwsValue()))(
        _.configFile
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckExplainability.wrap(buildAwsValue())
}
object DriftCheckExplainability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckExplainability =
      zio.aws.sagemaker.model.DriftCheckExplainability(
        constraints.map(value => value.asEditable),
        configFile.map(value => value.asEditable)
      )
    def constraints: Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def configFile: Option[zio.aws.sagemaker.model.FileSource.ReadOnly]
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
    def getConfigFile
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FileSource.ReadOnly] =
      AwsError.unwrapOptionField("configFile", configFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ) extends zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly {
    override val constraints
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.constraints())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val configFile
        : Option[zio.aws.sagemaker.model.FileSource.ReadOnly] = scala
      .Option(impl.configFile())
      .map(value => zio.aws.sagemaker.model.FileSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ): zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly = new Wrapper(
    impl
  )
}
