package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{RoleArn, MonitoringJobDefinitionName}
import scala.jdk.CollectionConverters._
final case class CreateModelQualityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName,
    modelQualityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelQualityBaselineConfig
    ] = None,
    modelQualityAppSpecification: zio.aws.sagemaker.model.ModelQualityAppSpecification,
    modelQualityJobInput: zio.aws.sagemaker.model.ModelQualityJobInput,
    modelQualityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest = {
    import CreateModelQualityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .optionallyWith(
        modelQualityBaselineConfig.map(value => value.buildAwsValue())
      )(_.modelQualityBaselineConfig)
      .modelQualityAppSpecification(
        modelQualityAppSpecification.buildAwsValue()
      )
      .modelQualityJobInput(modelQualityJobInput.buildAwsValue())
      .modelQualityJobOutputConfig(modelQualityJobOutputConfig.buildAwsValue())
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateModelQualityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest =
      zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest(
        jobDefinitionName,
        modelQualityBaselineConfig.map(value => value.asEditable),
        modelQualityAppSpecification.asEditable,
        modelQualityJobInput.asEditable,
        modelQualityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobDefinitionName: MonitoringJobDefinitionName
    def modelQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly]
    def modelQualityAppSpecification
        : zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly
    def modelQualityJobInput
        : zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly
    def modelQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getModelQualityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelQualityBaselineConfig",
      modelQualityBaselineConfig
    )
    def getModelQualityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly
    ] = ZIO.succeed(modelQualityAppSpecification)
    def getModelQualityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly
    ] = ZIO.succeed(modelQualityJobInput)
    def getModelQualityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(modelQualityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val modelQualityBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelQualityBaselineConfig.ReadOnly] =
      scala
        .Option(impl.modelQualityBaselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelQualityBaselineConfig.wrap(value)
        )
    override val modelQualityAppSpecification
        : zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.ModelQualityAppSpecification
        .wrap(impl.modelQualityAppSpecification())
    override val modelQualityJobInput
        : zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly =
      zio.aws.sagemaker.model.ModelQualityJobInput
        .wrap(impl.modelQualityJobInput())
    override val modelQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.modelQualityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest
  ): zio.aws.sagemaker.model.CreateModelQualityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
