package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelPackageArn
import scala.jdk.CollectionConverters._
final case class CreateModelPackageResponse(modelPackageArn: ModelPackageArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse = {
    import CreateModelPackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse
      .builder()
      .modelPackageArn(
        ModelPackageArn.unwrap(modelPackageArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageResponse.wrap(buildAwsValue())
}
object CreateModelPackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageResponse =
      zio.aws.sagemaker.model.CreateModelPackageResponse(modelPackageArn)
    def modelPackageArn: ModelPackageArn
    def getModelPackageArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse
  ) extends zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly {
    override val modelPackageArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn(impl.modelPackageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse
  ): zio.aws.sagemaker.model.CreateModelPackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
