package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  CustomerMetadataValue,
  S3Uri,
  CustomerMetadataKey,
  CertifyForMarketplace,
  ArnOrName,
  ClientToken,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class CreateModelPackageRequest(
    modelPackageName: Option[EntityName] = None,
    modelPackageGroupName: Option[ArnOrName] = None,
    modelPackageDescription: Option[EntityDescription] = None,
    inferenceSpecification: Option[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = None,
    validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification
    ] = None,
    sourceAlgorithmSpecification: Option[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification
    ] = None,
    certifyForMarketplace: Option[CertifyForMarketplace] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus] =
      None,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    modelMetrics: Option[zio.aws.sagemaker.model.ModelMetrics] = None,
    clientToken: Option[ClientToken] = None,
    customerMetadataProperties: Option[
      Map[CustomerMetadataKey, CustomerMetadataValue]
    ] = None,
    driftCheckBaselines: Option[zio.aws.sagemaker.model.DriftCheckBaselines] =
      None,
    domain: Option[String] = None,
    task: Option[String] = None,
    samplePayloadUrl: Option[S3Uri] = None,
    additionalInferenceSpecifications: Option[Iterable[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest = {
    import CreateModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
      .builder()
      .optionallyWith(
        modelPackageName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageName)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          ArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageDescription)
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .optionallyWith(
        sourceAlgorithmSpecification.map(value => value.buildAwsValue())
      )(_.sourceAlgorithmSpecification)
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(modelMetrics.map(value => value.buildAwsValue()))(
        _.modelMetrics
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        customerMetadataProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomerMetadataKey.unwrap(
                key
              ): java.lang.String) -> (CustomerMetadataValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customerMetadataProperties)
      .optionallyWith(driftCheckBaselines.map(value => value.buildAwsValue()))(
        _.driftCheckBaselines
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(
        samplePayloadUrl.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.samplePayloadUrl)
      .optionallyWith(
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalInferenceSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageRequest.wrap(buildAwsValue())
}
object CreateModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageRequest =
      zio.aws.sagemaker.model.CreateModelPackageRequest(
        modelPackageName.map(value => value),
        modelPackageGroupName.map(value => value),
        modelPackageDescription.map(value => value),
        inferenceSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        sourceAlgorithmSpecification.map(value => value.asEditable),
        certifyForMarketplace.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        modelApprovalStatus.map(value => value),
        metadataProperties.map(value => value.asEditable),
        modelMetrics.map(value => value.asEditable),
        clientToken.map(value => value),
        customerMetadataProperties.map(value => value),
        driftCheckBaselines.map(value => value.asEditable),
        domain.map(value => value),
        task.map(value => value),
        samplePayloadUrl.map(value => value),
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageName: Option[EntityName]
    def modelPackageGroupName: Option[ArnOrName]
    def modelPackageDescription: Option[EntityDescription]
    def inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ]
    def sourceAlgorithmSpecification
        : Option[zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly]
    def certifyForMarketplace: Option[CertifyForMarketplace]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus]
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def modelMetrics: Option[zio.aws.sagemaker.model.ModelMetrics.ReadOnly]
    def clientToken: Option[ClientToken]
    def customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]]
    def driftCheckBaselines
        : Option[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly]
    def domain: Option[String]
    def task: Option[String]
    def samplePayloadUrl: Option[S3Uri]
    def additionalInferenceSpecifications: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]]
    def getModelPackageName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageName", modelPackageName)
    def getModelPackageGroupName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageDescription",
        modelPackageDescription
      )
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getSourceAlgorithmSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceAlgorithmSpecification",
      sourceAlgorithmSpecification
    )
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getModelMetrics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCustomerMetadataProperties
        : ZIO[Any, AwsError, Map[CustomerMetadataKey, CustomerMetadataValue]] =
      AwsError.unwrapOptionField(
        "customerMetadataProperties",
        customerMetadataProperties
      )
    def getDriftCheckBaselines: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly
    ] = AwsError.unwrapOptionField("driftCheckBaselines", driftCheckBaselines)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getSamplePayloadUrl: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("samplePayloadUrl", samplePayloadUrl)
    def getAdditionalInferenceSpecifications: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalInferenceSpecifications",
      additionalInferenceSpecifications
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ) extends zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly {
    override val modelPackageName: Option[EntityName] = scala
      .Option(impl.modelPackageName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageGroupName: Option[ArnOrName] = scala
      .Option(impl.modelPackageGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val modelPackageDescription: Option[EntityDescription] = scala
      .Option(impl.modelPackageDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      scala
        .Option(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = scala
      .Option(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.ModelPackageValidationSpecification.wrap(value)
      )
    override val sourceAlgorithmSpecification: Option[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = scala
      .Option(impl.sourceAlgorithmSpecification())
      .map(value =>
        zio.aws.sagemaker.model.SourceAlgorithmSpecification.wrap(value)
      )
    override val certifyForMarketplace: Option[CertifyForMarketplace] = scala
      .Option(impl.certifyForMarketplace())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
      )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val modelApprovalStatus
        : Option[zio.aws.sagemaker.model.ModelApprovalStatus] = scala
      .Option(impl.modelApprovalStatus())
      .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val modelMetrics
        : Option[zio.aws.sagemaker.model.ModelMetrics.ReadOnly] = scala
      .Option(impl.modelMetrics())
      .map(value => zio.aws.sagemaker.model.ModelMetrics.wrap(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.sagemaker.model.primitives.ClientToken(value))
    override val customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]] = scala
      .Option(impl.customerMetadataProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.CustomerMetadataKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.CustomerMetadataValue(value)
          })
          .toMap
      )
    override val driftCheckBaselines
        : Option[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly] = scala
      .Option(impl.driftCheckBaselines())
      .map(value => zio.aws.sagemaker.model.DriftCheckBaselines.wrap(value))
    override val domain: Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val task: Option[String] =
      scala.Option(impl.task()).map(value => value: String)
    override val samplePayloadUrl: Option[S3Uri] = scala
      .Option(impl.samplePayloadUrl())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val additionalInferenceSpecifications: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = scala
      .Option(impl.additionalInferenceSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest
  ): zio.aws.sagemaker.model.CreateModelPackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
