package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.HumanTaskUiName
import scala.jdk.CollectionConverters._
final case class CreateHumanTaskUiRequest(
    humanTaskUiName: HumanTaskUiName,
    uiTemplate: zio.aws.sagemaker.model.UiTemplate,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest = {
    import CreateHumanTaskUiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest
      .builder()
      .humanTaskUiName(
        HumanTaskUiName.unwrap(humanTaskUiName): java.lang.String
      )
      .uiTemplate(uiTemplate.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateHumanTaskUiRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateHumanTaskUiRequest.wrap(buildAwsValue())
}
object CreateHumanTaskUiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateHumanTaskUiRequest =
      zio.aws.sagemaker.model.CreateHumanTaskUiRequest(
        humanTaskUiName,
        uiTemplate.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def humanTaskUiName: HumanTaskUiName
    def uiTemplate: zio.aws.sagemaker.model.UiTemplate.ReadOnly
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getHumanTaskUiName: ZIO[Any, Nothing, HumanTaskUiName] =
      ZIO.succeed(humanTaskUiName)
    def getUiTemplate
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.UiTemplate.ReadOnly] =
      ZIO.succeed(uiTemplate)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest
  ) extends zio.aws.sagemaker.model.CreateHumanTaskUiRequest.ReadOnly {
    override val humanTaskUiName: HumanTaskUiName =
      zio.aws.sagemaker.model.primitives.HumanTaskUiName(impl.humanTaskUiName())
    override val uiTemplate: zio.aws.sagemaker.model.UiTemplate.ReadOnly =
      zio.aws.sagemaker.model.UiTemplate.wrap(impl.uiTemplate())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest
  ): zio.aws.sagemaker.model.CreateHumanTaskUiRequest.ReadOnly = new Wrapper(
    impl
  )
}
