package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentDescription,
  String256,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters._
final case class CreateContextRequest(
    contextName: ExperimentEntityName,
    source: zio.aws.sagemaker.model.ContextSource,
    contextType: String256,
    description: Option[ExperimentDescription] = None,
    properties: Option[Map[StringParameterValue, StringParameterValue]] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateContextRequest = {
    import CreateContextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateContextRequest
      .builder()
      .contextName(ExperimentEntityName.unwrap(contextName): java.lang.String)
      .source(source.buildAwsValue())
      .contextType(String256.unwrap(contextType): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue
                .unwrap(key): java.lang.String) -> (StringParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateContextRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateContextRequest.wrap(buildAwsValue())
}
object CreateContextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateContextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateContextRequest =
      zio.aws.sagemaker.model.CreateContextRequest(
        contextName,
        source.asEditable,
        contextType,
        description.map(value => value),
        properties.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contextName: ExperimentEntityName
    def source: zio.aws.sagemaker.model.ContextSource.ReadOnly
    def contextType: String256
    def description: Option[ExperimentDescription]
    def properties: Option[Map[StringParameterValue, StringParameterValue]]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getContextName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(contextName)
    def getSource
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ContextSource.ReadOnly] =
      ZIO.succeed(source)
    def getContextType: ZIO[Any, Nothing, String256] = ZIO.succeed(contextType)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateContextRequest
  ) extends zio.aws.sagemaker.model.CreateContextRequest.ReadOnly {
    override val contextName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.contextName())
    override val source: zio.aws.sagemaker.model.ContextSource.ReadOnly =
      zio.aws.sagemaker.model.ContextSource.wrap(impl.source())
    override val contextType: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.contextType())
    override val description: Option[ExperimentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
      )
    override val properties
        : Option[Map[StringParameterValue, StringParameterValue]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(
              key
            ) -> zio.aws.sagemaker.model.primitives.StringParameterValue(value)
          })
          .toMap
      )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateContextRequest
  ): zio.aws.sagemaker.model.CreateContextRequest.ReadOnly = new Wrapper(impl)
}
