package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CaptureStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CaptureStatus
}
object CaptureStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CaptureStatus
  ): zio.aws.sagemaker.model.CaptureStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.CaptureStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CaptureStatus.STARTED =>
      val r = Started
      r
    case software.amazon.awssdk.services.sagemaker.model.CaptureStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CaptureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureStatus =
      software.amazon.awssdk.services.sagemaker.model.CaptureStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Started extends zio.aws.sagemaker.model.CaptureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureStatus =
      software.amazon.awssdk.services.sagemaker.model.CaptureStatus.STARTED
  }
  case object Stopped extends zio.aws.sagemaker.model.CaptureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureStatus =
      software.amazon.awssdk.services.sagemaker.model.CaptureStatus.STOPPED
  }
}
