package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  AutoMLFailureReason,
  Timestamp,
  CandidateName
}
import scala.jdk.CollectionConverters._
final case class AutoMLCandidate(
    candidateName: CandidateName,
    finalAutoMLJobObjectiveMetric: Option[
      zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric
    ] = None,
    objectiveStatus: zio.aws.sagemaker.model.ObjectiveStatus,
    candidateSteps: Iterable[zio.aws.sagemaker.model.AutoMLCandidateStep],
    candidateStatus: zio.aws.sagemaker.model.CandidateStatus,
    inferenceContainers: Option[
      Iterable[zio.aws.sagemaker.model.AutoMLContainerDefinition]
    ] = None,
    creationTime: Timestamp,
    endTime: Option[Timestamp] = None,
    lastModifiedTime: Timestamp,
    failureReason: Option[AutoMLFailureReason] = None,
    candidateProperties: Option[zio.aws.sagemaker.model.CandidateProperties] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate = {
    import AutoMLCandidate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate
      .builder()
      .candidateName(CandidateName.unwrap(candidateName): java.lang.String)
      .optionallyWith(
        finalAutoMLJobObjectiveMetric.map(value => value.buildAwsValue())
      )(_.finalAutoMLJobObjectiveMetric)
      .objectiveStatus(objectiveStatus.unwrap)
      .candidateSteps(candidateSteps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .candidateStatus(candidateStatus.unwrap)
      .optionallyWith(
        inferenceContainers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceContainers)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          AutoMLFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(candidateProperties.map(value => value.buildAwsValue()))(
        _.candidateProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly =
    zio.aws.sagemaker.model.AutoMLCandidate.wrap(buildAwsValue())
}
object AutoMLCandidate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLCandidate =
      zio.aws.sagemaker.model.AutoMLCandidate(
        candidateName,
        finalAutoMLJobObjectiveMetric.map(value => value.asEditable),
        objectiveStatus,
        candidateSteps.map { item =>
          item.asEditable
        },
        candidateStatus,
        inferenceContainers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime,
        endTime.map(value => value),
        lastModifiedTime,
        failureReason.map(value => value),
        candidateProperties.map(value => value.asEditable)
      )
    def candidateName: CandidateName
    def finalAutoMLJobObjectiveMetric
        : Option[zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly]
    def objectiveStatus: zio.aws.sagemaker.model.ObjectiveStatus
    def candidateSteps
        : List[zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly]
    def candidateStatus: zio.aws.sagemaker.model.CandidateStatus
    def inferenceContainers: Option[
      List[zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly]
    ]
    def creationTime: Timestamp
    def endTime: Option[Timestamp]
    def lastModifiedTime: Timestamp
    def failureReason: Option[AutoMLFailureReason]
    def candidateProperties
        : Option[zio.aws.sagemaker.model.CandidateProperties.ReadOnly]
    def getCandidateName: ZIO[Any, Nothing, CandidateName] =
      ZIO.succeed(candidateName)
    def getFinalAutoMLJobObjectiveMetric: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly
    ] = AwsError.unwrapOptionField(
      "finalAutoMLJobObjectiveMetric",
      finalAutoMLJobObjectiveMetric
    )
    def getObjectiveStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ObjectiveStatus] =
      ZIO.succeed(objectiveStatus)
    def getCandidateSteps: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly
    ]] = ZIO.succeed(candidateSteps)
    def getCandidateStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CandidateStatus] =
      ZIO.succeed(candidateStatus)
    def getInferenceContainers: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("inferenceContainers", inferenceContainers)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, AutoMLFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCandidateProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CandidateProperties.ReadOnly
    ] = AwsError.unwrapOptionField("candidateProperties", candidateProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate
  ) extends zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly {
    override val candidateName: CandidateName =
      zio.aws.sagemaker.model.primitives.CandidateName(impl.candidateName())
    override val finalAutoMLJobObjectiveMetric: Option[
      zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.ReadOnly
    ] = scala
      .Option(impl.finalAutoMLJobObjectiveMetric())
      .map(value =>
        zio.aws.sagemaker.model.FinalAutoMLJobObjectiveMetric.wrap(value)
      )
    override val objectiveStatus: zio.aws.sagemaker.model.ObjectiveStatus =
      zio.aws.sagemaker.model.ObjectiveStatus.wrap(impl.objectiveStatus())
    override val candidateSteps
        : List[zio.aws.sagemaker.model.AutoMLCandidateStep.ReadOnly] = impl
      .candidateSteps()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLCandidateStep.wrap(item)
      }
      .toList
    override val candidateStatus: zio.aws.sagemaker.model.CandidateStatus =
      zio.aws.sagemaker.model.CandidateStatus.wrap(impl.candidateStatus())
    override val inferenceContainers: Option[
      List[zio.aws.sagemaker.model.AutoMLContainerDefinition.ReadOnly]
    ] = scala
      .Option(impl.inferenceContainers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLContainerDefinition.wrap(item)
        }.toList
      )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val failureReason: Option[AutoMLFailureReason] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.sagemaker.model.primitives.AutoMLFailureReason(value)
      )
    override val candidateProperties
        : Option[zio.aws.sagemaker.model.CandidateProperties.ReadOnly] = scala
      .Option(impl.candidateProperties())
      .map(value => zio.aws.sagemaker.model.CandidateProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate
  ): zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly = new Wrapper(impl)
}
