package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{UserProfileName, DomainId}
import scala.jdk.CollectionConverters._
final case class UpdateUserProfileRequest(
    domainId: DomainId,
    userProfileName: UserProfileName,
    userSettings: Option[zio.aws.sagemaker.model.UserSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest = {
    import UpdateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .optionallyWith(userSettings.map(value => value.buildAwsValue()))(
        _.userSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateUserProfileRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateUserProfileRequest.wrap(buildAwsValue())
}
object UpdateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateUserProfileRequest =
      zio.aws.sagemaker.model.UpdateUserProfileRequest(
        domainId,
        userProfileName,
        userSettings.map(value => value.asEditable)
      )
    def domainId: DomainId
    def userProfileName: UserProfileName
    def userSettings: Option[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
    def getUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest
  ) extends zio.aws.sagemaker.model.UpdateUserProfileRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
    override val userSettings
        : Option[zio.aws.sagemaker.model.UserSettings.ReadOnly] = scala
      .Option(impl.userSettings())
      .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest
  ): zio.aws.sagemaker.model.UpdateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
