package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class UpdateTrialRequest(
    trialName: ExperimentEntityName,
    displayName: Option[ExperimentEntityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest = {
    import UpdateTrialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest
      .builder()
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrialRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrialRequest.wrap(buildAwsValue())
}
object UpdateTrialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrialRequest =
      zio.aws.sagemaker.model
        .UpdateTrialRequest(trialName, displayName.map(value => value))
    def trialName: ExperimentEntityName
    def displayName: Option[ExperimentEntityName]
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest
  ) extends zio.aws.sagemaker.model.UpdateTrialRequest.ReadOnly {
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest
  ): zio.aws.sagemaker.model.UpdateTrialRequest.ReadOnly = new Wrapper(impl)
}
