package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter
import scala.jdk.CollectionConverters._
final case class TrainingJobStatusCounters(
    completed: Option[TrainingJobStatusCounter] = None,
    inProgress: Option[TrainingJobStatusCounter] = None,
    retryableError: Option[TrainingJobStatusCounter] = None,
    nonRetryableError: Option[TrainingJobStatusCounter] = None,
    stopped: Option[TrainingJobStatusCounter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters = {
    import TrainingJobStatusCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
      .builder()
      .optionallyWith(
        completed.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.completed)
      .optionallyWith(
        inProgress.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.inProgress)
      .optionallyWith(
        retryableError.map(value =>
          TrainingJobStatusCounter.unwrap(value): Integer
        )
      )(_.retryableError)
      .optionallyWith(
        nonRetryableError.map(value =>
          TrainingJobStatusCounter.unwrap(value): Integer
        )
      )(_.nonRetryableError)
      .optionallyWith(
        stopped.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.stopped)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly =
    zio.aws.sagemaker.model.TrainingJobStatusCounters.wrap(buildAwsValue())
}
object TrainingJobStatusCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJobStatusCounters =
      zio.aws.sagemaker.model.TrainingJobStatusCounters(
        completed.map(value => value),
        inProgress.map(value => value),
        retryableError.map(value => value),
        nonRetryableError.map(value => value),
        stopped.map(value => value)
      )
    def completed: Option[TrainingJobStatusCounter]
    def inProgress: Option[TrainingJobStatusCounter]
    def retryableError: Option[TrainingJobStatusCounter]
    def nonRetryableError: Option[TrainingJobStatusCounter]
    def stopped: Option[TrainingJobStatusCounter]
    def getCompleted: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("completed", completed)
    def getInProgress: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("inProgress", inProgress)
    def getRetryableError: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("retryableError", retryableError)
    def getNonRetryableError: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("nonRetryableError", nonRetryableError)
    def getStopped: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("stopped", stopped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ) extends zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly {
    override val completed: Option[TrainingJobStatusCounter] = scala
      .Option(impl.completed())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
      )
    override val inProgress: Option[TrainingJobStatusCounter] = scala
      .Option(impl.inProgress())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
      )
    override val retryableError: Option[TrainingJobStatusCounter] = scala
      .Option(impl.retryableError())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
      )
    override val nonRetryableError: Option[TrainingJobStatusCounter] = scala
      .Option(impl.nonRetryableError())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
      )
    override val stopped: Option[TrainingJobStatusCounter] = scala
      .Option(impl.stopped())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ): zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly = new Wrapper(
    impl
  )
}
