package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetPlatform(
    os: zio.aws.sagemaker.model.TargetPlatformOs,
    arch: zio.aws.sagemaker.model.TargetPlatformArch,
    accelerator: Option[zio.aws.sagemaker.model.TargetPlatformAccelerator] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TargetPlatform = {
    import TargetPlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TargetPlatform
      .builder()
      .os(os.unwrap)
      .arch(arch.unwrap)
      .optionallyWith(accelerator.map(value => value.unwrap))(_.accelerator)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TargetPlatform.ReadOnly =
    zio.aws.sagemaker.model.TargetPlatform.wrap(buildAwsValue())
}
object TargetPlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TargetPlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TargetPlatform =
      zio.aws.sagemaker.model
        .TargetPlatform(os, arch, accelerator.map(value => value))
    def os: zio.aws.sagemaker.model.TargetPlatformOs
    def arch: zio.aws.sagemaker.model.TargetPlatformArch
    def accelerator: Option[zio.aws.sagemaker.model.TargetPlatformAccelerator]
    def getOs: ZIO[Any, Nothing, zio.aws.sagemaker.model.TargetPlatformOs] =
      ZIO.succeed(os)
    def getArch: ZIO[Any, Nothing, zio.aws.sagemaker.model.TargetPlatformArch] =
      ZIO.succeed(arch)
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TargetPlatformAccelerator
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TargetPlatform
  ) extends zio.aws.sagemaker.model.TargetPlatform.ReadOnly {
    override val os: zio.aws.sagemaker.model.TargetPlatformOs =
      zio.aws.sagemaker.model.TargetPlatformOs.wrap(impl.os())
    override val arch: zio.aws.sagemaker.model.TargetPlatformArch =
      zio.aws.sagemaker.model.TargetPlatformArch.wrap(impl.arch())
    override val accelerator
        : Option[zio.aws.sagemaker.model.TargetPlatformAccelerator] = scala
      .Option(impl.accelerator())
      .map(value =>
        zio.aws.sagemaker.model.TargetPlatformAccelerator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TargetPlatform
  ): zio.aws.sagemaker.model.TargetPlatform.ReadOnly = new Wrapper(impl)
}
