package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TransformJobName
import scala.jdk.CollectionConverters._
final case class StopTransformJobRequest(transformJobName: TransformJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest = {
    import StopTransformJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest
      .builder()
      .transformJobName(
        TransformJobName.unwrap(transformJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopTransformJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopTransformJobRequest.wrap(buildAwsValue())
}
object StopTransformJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopTransformJobRequest =
      zio.aws.sagemaker.model.StopTransformJobRequest(transformJobName)
    def transformJobName: TransformJobName
    def getTransformJobName: ZIO[Any, Nothing, TransformJobName] =
      ZIO.succeed(transformJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest
  ) extends zio.aws.sagemaker.model.StopTransformJobRequest.ReadOnly {
    override val transformJobName: TransformJobName =
      zio.aws.sagemaker.model.primitives
        .TransformJobName(impl.transformJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest
  ): zio.aws.sagemaker.model.StopTransformJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
