package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProcessingMaxRuntimeInSeconds
import scala.jdk.CollectionConverters._
final case class ProcessingStoppingCondition(
    maxRuntimeInSeconds: ProcessingMaxRuntimeInSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition = {
    import ProcessingStoppingCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition
      .builder()
      .maxRuntimeInSeconds(
        ProcessingMaxRuntimeInSeconds.unwrap(maxRuntimeInSeconds): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly =
    zio.aws.sagemaker.model.ProcessingStoppingCondition.wrap(buildAwsValue())
}
object ProcessingStoppingCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingStoppingCondition =
      zio.aws.sagemaker.model.ProcessingStoppingCondition(maxRuntimeInSeconds)
    def maxRuntimeInSeconds: ProcessingMaxRuntimeInSeconds
    def getMaxRuntimeInSeconds
        : ZIO[Any, Nothing, ProcessingMaxRuntimeInSeconds] =
      ZIO.succeed(maxRuntimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition
  ) extends zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly {
    override val maxRuntimeInSeconds: ProcessingMaxRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives
        .ProcessingMaxRuntimeInSeconds(impl.maxRuntimeInSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingStoppingCondition
  ): zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly = new Wrapper(
    impl
  )
}
