package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  LastModifiedTime,
  NotebookInstanceArn,
  NotebookInstanceUrl,
  NotebookInstanceName,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName
}
import scala.jdk.CollectionConverters._
final case class NotebookInstanceSummary(
    notebookInstanceName: NotebookInstanceName,
    notebookInstanceArn: NotebookInstanceArn,
    notebookInstanceStatus: Option[
      zio.aws.sagemaker.model.NotebookInstanceStatus
    ] = None,
    url: Option[NotebookInstanceUrl] = None,
    instanceType: Option[zio.aws.sagemaker.model.InstanceType] = None,
    creationTime: Option[CreationTime] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    notebookInstanceLifecycleConfigName: Option[
      NotebookInstanceLifecycleConfigName
    ] = None,
    defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = None,
    additionalCodeRepositories: Option[Iterable[CodeRepositoryNameOrUrl]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary = {
    import NotebookInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .notebookInstanceArn(
        NotebookInstanceArn.unwrap(notebookInstanceArn): java.lang.String
      )
      .optionallyWith(notebookInstanceStatus.map(value => value.unwrap))(
        _.notebookInstanceStatus
      )
      .optionallyWith(
        url.map(value => NotebookInstanceUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly =
    zio.aws.sagemaker.model.NotebookInstanceSummary.wrap(buildAwsValue())
}
object NotebookInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NotebookInstanceSummary =
      zio.aws.sagemaker.model.NotebookInstanceSummary(
        notebookInstanceName,
        notebookInstanceArn,
        notebookInstanceStatus.map(value => value),
        url.map(value => value),
        instanceType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value)
      )
    def notebookInstanceName: NotebookInstanceName
    def notebookInstanceArn: NotebookInstanceArn
    def notebookInstanceStatus
        : Option[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def url: Option[NotebookInstanceUrl]
    def instanceType: Option[zio.aws.sagemaker.model.InstanceType]
    def creationTime: Option[CreationTime]
    def lastModifiedTime: Option[LastModifiedTime]
    def notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName]
    def defaultCodeRepository: Option[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Option[List[CodeRepositoryNameOrUrl]]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getNotebookInstanceArn: ZIO[Any, Nothing, NotebookInstanceArn] =
      ZIO.succeed(notebookInstanceArn)
    def getNotebookInstanceStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField(
        "notebookInstanceStatus",
        notebookInstanceStatus
      )
    def getUrl: ZIO[Any, AwsError, NotebookInstanceUrl] =
      AwsError.unwrapOptionField("url", url)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ) extends zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val notebookInstanceArn: NotebookInstanceArn =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceArn(impl.notebookInstanceArn())
    override val notebookInstanceStatus
        : Option[zio.aws.sagemaker.model.NotebookInstanceStatus] = scala
      .Option(impl.notebookInstanceStatus())
      .map(value => zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value))
    override val url: Option[NotebookInstanceUrl] = scala
      .Option(impl.url())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceUrl(value)
      )
    override val instanceType: Option[zio.aws.sagemaker.model.InstanceType] =
      scala
        .Option(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val defaultCodeRepository: Option[CodeRepositoryNameOrUrl] = scala
      .Option(impl.defaultCodeRepository())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
    override val additionalCodeRepositories
        : Option[List[CodeRepositoryNameOrUrl]] = scala
      .Option(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ): zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly = new Wrapper(
    impl
  )
}
