package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, WorkteamName}
import scala.jdk.CollectionConverters._
final case class ListWorkteamsRequest(
    sortBy: Option[zio.aws.sagemaker.model.ListWorkteamsSortByOptions] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nameContains: Option[WorkteamName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest = {
    import ListWorkteamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value => WorkteamName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListWorkteamsRequest.wrap(buildAwsValue())
}
object ListWorkteamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListWorkteamsRequest =
      zio.aws.sagemaker.model.ListWorkteamsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sortBy: Option[zio.aws.sagemaker.model.ListWorkteamsSortByOptions]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nameContains: Option[WorkteamName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListWorkteamsSortByOptions
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains: ZIO[Any, AwsError, WorkteamName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ) extends zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly {
    override val sortBy
        : Option[zio.aws.sagemaker.model.ListWorkteamsSortByOptions] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.ListWorkteamsSortByOptions.wrap(value)
      )
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nameContains: Option[WorkteamName] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.WorkteamName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest
  ): zio.aws.sagemaker.model.ListWorkteamsRequest.ReadOnly = new Wrapper(impl)
}
