package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListExperimentsResponse(
    experimentSummaries: Option[
      Iterable[zio.aws.sagemaker.model.ExperimentSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse = {
    import ListExperimentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse
      .builder()
      .optionallyWith(
        experimentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.experimentSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListExperimentsResponse.wrap(buildAwsValue())
}
object ListExperimentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListExperimentsResponse =
      zio.aws.sagemaker.model.ListExperimentsResponse(
        experimentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def experimentSummaries
        : Option[List[zio.aws.sagemaker.model.ExperimentSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getExperimentSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ExperimentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("experimentSummaries", experimentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse
  ) extends zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly {
    override val experimentSummaries
        : Option[List[zio.aws.sagemaker.model.ExperimentSummary.ReadOnly]] =
      scala
        .Option(impl.experimentSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ExperimentSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse
  ): zio.aws.sagemaker.model.ListExperimentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
