package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class LabelingJobS3DataSource(manifestS3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource = {
    import LabelingJobS3DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource
      .builder()
      .manifestS3Uri(S3Uri.unwrap(manifestS3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobS3DataSource.wrap(buildAwsValue())
}
object LabelingJobS3DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobS3DataSource =
      zio.aws.sagemaker.model.LabelingJobS3DataSource(manifestS3Uri)
    def manifestS3Uri: S3Uri
    def getManifestS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(manifestS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource
  ) extends zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly {
    override val manifestS3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.manifestS3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobS3DataSource
  ): zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly = new Wrapper(
    impl
  )
}
