package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ModelArn, S3Uri}
import scala.jdk.CollectionConverters._
final case class LabelingJobOutput(
    outputDatasetS3Uri: S3Uri,
    finalActiveLearningModelArn: Option[ModelArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput = {
    import LabelingJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput
      .builder()
      .outputDatasetS3Uri(S3Uri.unwrap(outputDatasetS3Uri): java.lang.String)
      .optionallyWith(
        finalActiveLearningModelArn.map(value =>
          ModelArn.unwrap(value): java.lang.String
        )
      )(_.finalActiveLearningModelArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobOutput.wrap(buildAwsValue())
}
object LabelingJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobOutput =
      zio.aws.sagemaker.model.LabelingJobOutput(
        outputDatasetS3Uri,
        finalActiveLearningModelArn.map(value => value)
      )
    def outputDatasetS3Uri: S3Uri
    def finalActiveLearningModelArn: Option[ModelArn]
    def getOutputDatasetS3Uri: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(outputDatasetS3Uri)
    def getFinalActiveLearningModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField(
        "finalActiveLearningModelArn",
        finalActiveLearningModelArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput
  ) extends zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly {
    override val outputDatasetS3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.outputDatasetS3Uri())
    override val finalActiveLearningModelArn: Option[ModelArn] = scala
      .Option(impl.finalActiveLearningModelArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput
  ): zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly = new Wrapper(impl)
}
