package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class DisassociateTrialComponentRequest(
    trialComponentName: ExperimentEntityName,
    trialName: ExperimentEntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest = {
    import DisassociateTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DisassociateTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.DisassociateTrialComponentRequest
      .wrap(buildAwsValue())
}
object DisassociateTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DisassociateTrialComponentRequest =
      zio.aws.sagemaker.model
        .DisassociateTrialComponentRequest(trialComponentName, trialName)
    def trialComponentName: ExperimentEntityName
    def trialName: ExperimentEntityName
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest
  ) extends zio.aws.sagemaker.model.DisassociateTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest
  ): zio.aws.sagemaker.model.DisassociateTrialComponentRequest.ReadOnly =
    new Wrapper(impl)
}
