package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{UserProfileName, DomainId}
import scala.jdk.CollectionConverters._
final case class DescribeUserProfileRequest(
    domainId: DomainId,
    userProfileName: UserProfileName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest = {
    import DescribeUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeUserProfileRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeUserProfileRequest.wrap(buildAwsValue())
}
object DescribeUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeUserProfileRequest =
      zio.aws.sagemaker.model
        .DescribeUserProfileRequest(domainId, userProfileName)
    def domainId: DomainId
    def userProfileName: UserProfileName
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest
  ) extends zio.aws.sagemaker.model.DescribeUserProfileRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest
  ): zio.aws.sagemaker.model.DescribeUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
