package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  KmsKeyId,
  EndpointConfigArn,
  EndpointConfigName
}
import scala.jdk.CollectionConverters._
final case class DescribeEndpointConfigResponse(
    endpointConfigName: EndpointConfigName,
    endpointConfigArn: EndpointConfigArn,
    productionVariants: Iterable[zio.aws.sagemaker.model.ProductionVariant],
    dataCaptureConfig: Option[zio.aws.sagemaker.model.DataCaptureConfig] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    creationTime: Timestamp,
    asyncInferenceConfig: Option[zio.aws.sagemaker.model.AsyncInferenceConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse = {
    import DescribeEndpointConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .endpointConfigArn(
        EndpointConfigArn.unwrap(endpointConfigArn): java.lang.String
      )
      .productionVariants(productionVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(asyncInferenceConfig.map(value => value.buildAwsValue()))(
        _.asyncInferenceConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEndpointConfigResponse.wrap(buildAwsValue())
}
object DescribeEndpointConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEndpointConfigResponse =
      zio.aws.sagemaker.model.DescribeEndpointConfigResponse(
        endpointConfigName,
        endpointConfigArn,
        productionVariants.map { item =>
          item.asEditable
        },
        dataCaptureConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value),
        creationTime,
        asyncInferenceConfig.map(value => value.asEditable)
      )
    def endpointConfigName: EndpointConfigName
    def endpointConfigArn: EndpointConfigArn
    def productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly]
    def dataCaptureConfig
        : Option[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly]
    def kmsKeyId: Option[KmsKeyId]
    def creationTime: Timestamp
    def asyncInferenceConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly]
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getEndpointConfigArn: ZIO[Any, Nothing, EndpointConfigArn] =
      ZIO.succeed(endpointConfigArn)
    def getProductionVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProductionVariant.ReadOnly
    ]] = ZIO.succeed(productionVariants)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getAsyncInferenceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("asyncInferenceConfig", asyncInferenceConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val endpointConfigArn: EndpointConfigArn =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigArn(impl.endpointConfigArn())
    override val productionVariants
        : List[zio.aws.sagemaker.model.ProductionVariant.ReadOnly] = impl
      .productionVariants()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProductionVariant.wrap(item)
      }
      .toList
    override val dataCaptureConfig
        : Option[zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly] = scala
      .Option(impl.dataCaptureConfig())
      .map(value => zio.aws.sagemaker.model.DataCaptureConfig.wrap(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val asyncInferenceConfig
        : Option[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly] = scala
      .Option(impl.asyncInferenceConfig())
      .map(value => zio.aws.sagemaker.model.AsyncInferenceConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse
  ): zio.aws.sagemaker.model.DescribeEndpointConfigResponse.ReadOnly =
    new Wrapper(impl)
}
