package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  String1024,
  SecurityGroupId,
  FailureReason,
  DomainName,
  LastModifiedTime,
  DomainId,
  DomainArn,
  KmsKeyId,
  ResourceId,
  String256
}
import scala.jdk.CollectionConverters._
final case class DescribeDomainResponse(
    domainArn: Option[DomainArn] = None,
    domainId: Option[DomainId] = None,
    domainName: Option[DomainName] = None,
    homeEfsFileSystemId: Option[ResourceId] = None,
    singleSignOnManagedApplicationInstanceId: Option[String256] = None,
    status: Option[zio.aws.sagemaker.model.DomainStatus] = None,
    creationTime: Option[CreationTime] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    failureReason: Option[FailureReason] = None,
    authMode: Option[zio.aws.sagemaker.model.AuthMode] = None,
    defaultUserSettings: Option[zio.aws.sagemaker.model.UserSettings] = None,
    appNetworkAccessType: Option[zio.aws.sagemaker.model.AppNetworkAccessType] =
      None,
    homeEfsFileSystemKmsKeyId: Option[KmsKeyId] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    url: Option[String1024] = None,
    vpcId: Option[VpcId] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    domainSettings: Option[zio.aws.sagemaker.model.DomainSettings] = None,
    appSecurityGroupManagement: Option[
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = None,
    securityGroupIdForDomainBoundary: Option[SecurityGroupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse = {
    import DescribeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
      .builder()
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        homeEfsFileSystemId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemId)
      .optionallyWith(
        singleSignOnManagedApplicationInstanceId.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.singleSignOnManagedApplicationInstanceId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(defaultUserSettings.map(value => value.buildAwsValue()))(
        _.defaultUserSettings
      )
      .optionallyWith(appNetworkAccessType.map(value => value.unwrap))(
        _.appNetworkAccessType
      )
      .optionallyWith(
        homeEfsFileSystemKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.homeEfsFileSystemKmsKeyId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        url.map(value => String1024.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(domainSettings.map(value => value.buildAwsValue()))(
        _.domainSettings
      )
      .optionallyWith(appSecurityGroupManagement.map(value => value.unwrap))(
        _.appSecurityGroupManagement
      )
      .optionallyWith(
        securityGroupIdForDomainBoundary.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.securityGroupIdForDomainBoundary)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeDomainResponse.wrap(buildAwsValue())
}
object DescribeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDomainResponse =
      zio.aws.sagemaker.model.DescribeDomainResponse(
        domainArn.map(value => value),
        domainId.map(value => value),
        domainName.map(value => value),
        homeEfsFileSystemId.map(value => value),
        singleSignOnManagedApplicationInstanceId.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        failureReason.map(value => value),
        authMode.map(value => value),
        defaultUserSettings.map(value => value.asEditable),
        appNetworkAccessType.map(value => value),
        homeEfsFileSystemKmsKeyId.map(value => value),
        subnetIds.map(value => value),
        url.map(value => value),
        vpcId.map(value => value),
        kmsKeyId.map(value => value),
        domainSettings.map(value => value.asEditable),
        appSecurityGroupManagement.map(value => value),
        securityGroupIdForDomainBoundary.map(value => value)
      )
    def domainArn: Option[DomainArn]
    def domainId: Option[DomainId]
    def domainName: Option[DomainName]
    def homeEfsFileSystemId: Option[ResourceId]
    def singleSignOnManagedApplicationInstanceId: Option[String256]
    def status: Option[zio.aws.sagemaker.model.DomainStatus]
    def creationTime: Option[CreationTime]
    def lastModifiedTime: Option[LastModifiedTime]
    def failureReason: Option[FailureReason]
    def authMode: Option[zio.aws.sagemaker.model.AuthMode]
    def defaultUserSettings
        : Option[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def appNetworkAccessType
        : Option[zio.aws.sagemaker.model.AppNetworkAccessType]
    def homeEfsFileSystemKmsKeyId: Option[KmsKeyId]
    def subnetIds: Option[List[SubnetId]]
    def url: Option[String1024]
    def vpcId: Option[VpcId]
    def kmsKeyId: Option[KmsKeyId]
    def domainSettings: Option[zio.aws.sagemaker.model.DomainSettings.ReadOnly]
    def appSecurityGroupManagement
        : Option[zio.aws.sagemaker.model.AppSecurityGroupManagement]
    def securityGroupIdForDomainBoundary: Option[SecurityGroupId]
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getHomeEfsFileSystemId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("homeEfsFileSystemId", homeEfsFileSystemId)
    def getSingleSignOnManagedApplicationInstanceId
        : ZIO[Any, AwsError, String256] = AwsError.unwrapOptionField(
      "singleSignOnManagedApplicationInstanceId",
      singleSignOnManagedApplicationInstanceId
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getDefaultUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("defaultUserSettings", defaultUserSettings)
    def getAppNetworkAccessType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AppNetworkAccessType] =
      AwsError.unwrapOptionField("appNetworkAccessType", appNetworkAccessType)
    def getHomeEfsFileSystemKmsKeyId: ZIO[Any, AwsError, KmsKeyId] = AwsError
      .unwrapOptionField("homeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getUrl: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("url", url)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDomainSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DomainSettings.ReadOnly] =
      AwsError.unwrapOptionField("domainSettings", domainSettings)
    def getAppSecurityGroupManagement: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = AwsError.unwrapOptionField(
      "appSecurityGroupManagement",
      appSecurityGroupManagement
    )
    def getSecurityGroupIdForDomainBoundary
        : ZIO[Any, AwsError, SecurityGroupId] = AwsError.unwrapOptionField(
      "securityGroupIdForDomainBoundary",
      securityGroupIdForDomainBoundary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ) extends zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly {
    override val domainArn: Option[DomainArn] = scala
      .Option(impl.domainArn())
      .map(value => zio.aws.sagemaker.model.primitives.DomainArn(value))
    override val domainId: Option[DomainId] = scala
      .Option(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.sagemaker.model.primitives.DomainName(value))
    override val homeEfsFileSystemId: Option[ResourceId] = scala
      .Option(impl.homeEfsFileSystemId())
      .map(value => zio.aws.sagemaker.model.primitives.ResourceId(value))
    override val singleSignOnManagedApplicationInstanceId: Option[String256] =
      scala
        .Option(impl.singleSignOnManagedApplicationInstanceId())
        .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val status: Option[zio.aws.sagemaker.model.DomainStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.sagemaker.model.DomainStatus.wrap(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val authMode: Option[zio.aws.sagemaker.model.AuthMode] = scala
      .Option(impl.authMode())
      .map(value => zio.aws.sagemaker.model.AuthMode.wrap(value))
    override val defaultUserSettings
        : Option[zio.aws.sagemaker.model.UserSettings.ReadOnly] = scala
      .Option(impl.defaultUserSettings())
      .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
    override val appNetworkAccessType
        : Option[zio.aws.sagemaker.model.AppNetworkAccessType] = scala
      .Option(impl.appNetworkAccessType())
      .map(value => zio.aws.sagemaker.model.AppNetworkAccessType.wrap(value))
    override val homeEfsFileSystemKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.homeEfsFileSystemKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SubnetId(item)
        }.toList
      )
    override val url: Option[String1024] = scala
      .Option(impl.url())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.sagemaker.model.primitives.VpcId(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val domainSettings
        : Option[zio.aws.sagemaker.model.DomainSettings.ReadOnly] = scala
      .Option(impl.domainSettings())
      .map(value => zio.aws.sagemaker.model.DomainSettings.wrap(value))
    override val appSecurityGroupManagement
        : Option[zio.aws.sagemaker.model.AppSecurityGroupManagement] = scala
      .Option(impl.appSecurityGroupManagement())
      .map(value =>
        zio.aws.sagemaker.model.AppSecurityGroupManagement.wrap(value)
      )
    override val securityGroupIdForDomainBoundary: Option[SecurityGroupId] =
      scala
        .Option(impl.securityGroupIdForDomainBoundary())
        .map(value => zio.aws.sagemaker.model.primitives.SecurityGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse
  ): zio.aws.sagemaker.model.DescribeDomainResponse.ReadOnly = new Wrapper(impl)
}
