package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ActionArn
import scala.jdk.CollectionConverters._
final case class UpdateActionResponse(actionArn: Option[ActionArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse = {
    import UpdateActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse
      .builder()
      .optionallyWith(
        actionArn.map(value => ActionArn.unwrap(value): java.lang.String)
      )(_.actionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateActionResponse.wrap(buildAwsValue())
}
object UpdateActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateActionResponse =
      zio.aws.sagemaker.model
        .UpdateActionResponse(actionArn.map(value => value))
    def actionArn: Option[ActionArn]
    def getActionArn: ZIO[Any, AwsError, ActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse
  ) extends zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly {
    override val actionArn: Option[ActionArn] = scala
      .Option(impl.actionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ActionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse
  ): zio.aws.sagemaker.model.UpdateActionResponse.ReadOnly = new Wrapper(impl)
}
