package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.WaitIntervalInSeconds
import scala.jdk.CollectionConverters._
final case class TrafficRoutingConfig(
    `type`: zio.aws.sagemaker.model.TrafficRoutingConfigType,
    waitIntervalInSeconds: WaitIntervalInSeconds,
    canarySize: Option[zio.aws.sagemaker.model.CapacitySize] = None,
    linearStepSize: Option[zio.aws.sagemaker.model.CapacitySize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfig = {
    import TrafficRoutingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfig
      .builder()
      .`type`(`type`.unwrap)
      .waitIntervalInSeconds(
        WaitIntervalInSeconds.unwrap(waitIntervalInSeconds): Integer
      )
      .optionallyWith(canarySize.map(value => value.buildAwsValue()))(
        _.canarySize
      )
      .optionallyWith(linearStepSize.map(value => value.buildAwsValue()))(
        _.linearStepSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly =
    zio.aws.sagemaker.model.TrafficRoutingConfig.wrap(buildAwsValue())
}
object TrafficRoutingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrafficRoutingConfig =
      zio.aws.sagemaker.model.TrafficRoutingConfig(
        `type`,
        waitIntervalInSeconds,
        canarySize.map(value => value.asEditable),
        linearStepSize.map(value => value.asEditable)
      )
    def `type`: zio.aws.sagemaker.model.TrafficRoutingConfigType
    def waitIntervalInSeconds: WaitIntervalInSeconds
    def canarySize: Option[zio.aws.sagemaker.model.CapacitySize.ReadOnly]
    def linearStepSize: Option[zio.aws.sagemaker.model.CapacitySize.ReadOnly]
    def getType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrafficRoutingConfigType] =
      ZIO.succeed(`type`)
    def getWaitIntervalInSeconds: ZIO[Any, Nothing, WaitIntervalInSeconds] =
      ZIO.succeed(waitIntervalInSeconds)
    def getCanarySize
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CapacitySize.ReadOnly] =
      AwsError.unwrapOptionField("canarySize", canarySize)
    def getLinearStepSize
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CapacitySize.ReadOnly] =
      AwsError.unwrapOptionField("linearStepSize", linearStepSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfig
  ) extends zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly {
    override val `type`: zio.aws.sagemaker.model.TrafficRoutingConfigType =
      zio.aws.sagemaker.model.TrafficRoutingConfigType.wrap(impl.`type`())
    override val waitIntervalInSeconds: WaitIntervalInSeconds =
      zio.aws.sagemaker.model.primitives
        .WaitIntervalInSeconds(impl.waitIntervalInSeconds())
    override val canarySize
        : Option[zio.aws.sagemaker.model.CapacitySize.ReadOnly] = scala
      .Option(impl.canarySize())
      .map(value => zio.aws.sagemaker.model.CapacitySize.wrap(value))
    override val linearStepSize
        : Option[zio.aws.sagemaker.model.CapacitySize.ReadOnly] = scala
      .Option(impl.linearStepSize())
      .map(value => zio.aws.sagemaker.model.CapacitySize.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfig
  ): zio.aws.sagemaker.model.TrafficRoutingConfig.ReadOnly = new Wrapper(impl)
}
