package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  IdempotencyToken,
  PipelineExecutionDescription,
  PipelineExecutionName,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class StartPipelineExecutionRequest(
    pipelineName: PipelineName,
    pipelineExecutionDisplayName: Option[PipelineExecutionName] = None,
    pipelineParameters: Option[Iterable[zio.aws.sagemaker.model.Parameter]] =
      None,
    pipelineExecutionDescription: Option[PipelineExecutionDescription] = None,
    clientRequestToken: IdempotencyToken,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest = {
    import StartPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        pipelineExecutionDisplayName.map(value =>
          PipelineExecutionName.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDisplayName)
      .optionallyWith(
        pipelineParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineParameters)
      .optionallyWith(
        pipelineExecutionDescription.map(value =>
          PipelineExecutionDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDescription)
      .clientRequestToken(
        IdempotencyToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartPipelineExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.StartPipelineExecutionRequest.wrap(buildAwsValue())
}
object StartPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartPipelineExecutionRequest =
      zio.aws.sagemaker.model.StartPipelineExecutionRequest(
        pipelineName,
        pipelineExecutionDisplayName.map(value => value),
        pipelineParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pipelineExecutionDescription.map(value => value),
        clientRequestToken,
        parallelismConfiguration.map(value => value.asEditable)
      )
    def pipelineName: PipelineName
    def pipelineExecutionDisplayName: Option[PipelineExecutionName]
    def pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]]
    def pipelineExecutionDescription: Option[PipelineExecutionDescription]
    def clientRequestToken: IdempotencyToken
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineExecutionDisplayName
        : ZIO[Any, AwsError, PipelineExecutionName] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDisplayName",
        pipelineExecutionDisplayName
      )
    def getPipelineParameters
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("pipelineParameters", pipelineParameters)
    def getPipelineExecutionDescription
        : ZIO[Any, AwsError, PipelineExecutionDescription] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDescription",
        pipelineExecutionDescription
      )
    def getClientRequestToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(clientRequestToken)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest
  ) extends zio.aws.sagemaker.model.StartPipelineExecutionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineExecutionDisplayName: Option[PipelineExecutionName] =
      scala
        .Option(impl.pipelineExecutionDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionName(value)
        )
    override val pipelineParameters
        : Option[List[zio.aws.sagemaker.model.Parameter.ReadOnly]] = scala
      .Option(impl.pipelineParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.Parameter.wrap(item)
        }.toList
      )
    override val pipelineExecutionDescription
        : Option[PipelineExecutionDescription] = scala
      .Option(impl.pipelineExecutionDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionDescription(value)
      )
    override val clientRequestToken: IdempotencyToken =
      zio.aws.sagemaker.model.primitives
        .IdempotencyToken(impl.clientRequestToken())
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest
  ): zio.aws.sagemaker.model.StartPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
