package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  DirectoryPath,
  ConfigValue,
  S3Uri,
  OptionalVolumeSizeInGB,
  AlgorithmImage,
  RuleConfigurationName,
  ConfigKey
}
import scala.jdk.CollectionConverters._
final case class ProfilerRuleConfiguration(
    ruleConfigurationName: RuleConfigurationName,
    localPath: Option[DirectoryPath] = None,
    s3OutputPath: Option[S3Uri] = None,
    ruleEvaluatorImage: AlgorithmImage,
    instanceType: Option[zio.aws.sagemaker.model.ProcessingInstanceType] = None,
    volumeSizeInGB: Option[OptionalVolumeSizeInGB] = None,
    ruleParameters: Option[Map[ConfigKey, ConfigValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration = {
    import ProfilerRuleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration
      .builder()
      .ruleConfigurationName(
        RuleConfigurationName.unwrap(ruleConfigurationName): java.lang.String
      )
      .optionallyWith(
        localPath.map(value => DirectoryPath.unwrap(value): java.lang.String)
      )(_.localPath)
      .optionallyWith(
        s3OutputPath.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3OutputPath)
      .ruleEvaluatorImage(
        AlgorithmImage.unwrap(ruleEvaluatorImage): java.lang.String
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        volumeSizeInGB.map(value =>
          OptionalVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        ruleParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.ruleParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly =
    zio.aws.sagemaker.model.ProfilerRuleConfiguration.wrap(buildAwsValue())
}
object ProfilerRuleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProfilerRuleConfiguration =
      zio.aws.sagemaker.model.ProfilerRuleConfiguration(
        ruleConfigurationName,
        localPath.map(value => value),
        s3OutputPath.map(value => value),
        ruleEvaluatorImage,
        instanceType.map(value => value),
        volumeSizeInGB.map(value => value),
        ruleParameters.map(value => value)
      )
    def ruleConfigurationName: RuleConfigurationName
    def localPath: Option[DirectoryPath]
    def s3OutputPath: Option[S3Uri]
    def ruleEvaluatorImage: AlgorithmImage
    def instanceType: Option[zio.aws.sagemaker.model.ProcessingInstanceType]
    def volumeSizeInGB: Option[OptionalVolumeSizeInGB]
    def ruleParameters: Option[Map[ConfigKey, ConfigValue]]
    def getRuleConfigurationName: ZIO[Any, Nothing, RuleConfigurationName] =
      ZIO.succeed(ruleConfigurationName)
    def getLocalPath: ZIO[Any, AwsError, DirectoryPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3OutputPath: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
    def getRuleEvaluatorImage: ZIO[Any, Nothing, AlgorithmImage] =
      ZIO.succeed(ruleEvaluatorImage)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingInstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getVolumeSizeInGB: ZIO[Any, AwsError, OptionalVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getRuleParameters: ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("ruleParameters", ruleParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration
  ) extends zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly {
    override val ruleConfigurationName: RuleConfigurationName =
      zio.aws.sagemaker.model.primitives
        .RuleConfigurationName(impl.ruleConfigurationName())
    override val localPath: Option[DirectoryPath] = scala
      .Option(impl.localPath())
      .map(value => zio.aws.sagemaker.model.primitives.DirectoryPath(value))
    override val s3OutputPath: Option[S3Uri] = scala
      .Option(impl.s3OutputPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val ruleEvaluatorImage: AlgorithmImage =
      zio.aws.sagemaker.model.primitives
        .AlgorithmImage(impl.ruleEvaluatorImage())
    override val instanceType
        : Option[zio.aws.sagemaker.model.ProcessingInstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.sagemaker.model.ProcessingInstanceType.wrap(value))
    override val volumeSizeInGB: Option[OptionalVolumeSizeInGB] = scala
      .Option(impl.volumeSizeInGB())
      .map(value =>
        zio.aws.sagemaker.model.primitives.OptionalVolumeSizeInGB(value)
      )
    override val ruleParameters: Option[Map[ConfigKey, ConfigValue]] = scala
      .Option(impl.ruleParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.ConfigKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration
  ): zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
