package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Group
import scala.jdk.CollectionConverters._
final case class OidcMemberDefinition(groups: Iterable[Group]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition = {
    import OidcMemberDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition
      .builder()
      .groups(groups.map { item =>
        Group.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly =
    zio.aws.sagemaker.model.OidcMemberDefinition.wrap(buildAwsValue())
}
object OidcMemberDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OidcMemberDefinition =
      zio.aws.sagemaker.model.OidcMemberDefinition(groups)
    def groups: List[Group]
    def getGroups: ZIO[Any, Nothing, List[Group]] = ZIO.succeed(groups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition
  ) extends zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly {
    override val groups: List[Group] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.Group(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcMemberDefinition
  ): zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly = new Wrapper(impl)
}
