package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModelQualityJobInput(
    endpointInput: zio.aws.sagemaker.model.EndpointInput,
    groundTruthS3Input: zio.aws.sagemaker.model.MonitoringGroundTruthS3Input
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput = {
    import ModelQualityJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput
      .builder()
      .endpointInput(endpointInput.buildAwsValue())
      .groundTruthS3Input(groundTruthS3Input.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly =
    zio.aws.sagemaker.model.ModelQualityJobInput.wrap(buildAwsValue())
}
object ModelQualityJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelQualityJobInput =
      zio.aws.sagemaker.model.ModelQualityJobInput(
        endpointInput.asEditable,
        groundTruthS3Input.asEditable
      )
    def endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly
    def groundTruthS3Input
        : zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly
    def getEndpointInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      ZIO.succeed(endpointInput)
    def getGroundTruthS3Input: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly
    ] = ZIO.succeed(groundTruthS3Input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput
  ) extends zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly {
    override val endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
      zio.aws.sagemaker.model.EndpointInput.wrap(impl.endpointInput())
    override val groundTruthS3Input
        : zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly =
      zio.aws.sagemaker.model.MonitoringGroundTruthS3Input
        .wrap(impl.groundTruthS3Input())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityJobInput
  ): zio.aws.sagemaker.model.ModelQualityJobInput.ReadOnly = new Wrapper(impl)
}
