package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTrialsResponse(
    trialSummaries: Option[Iterable[zio.aws.sagemaker.model.TrialSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse = {
    import ListTrialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse
      .builder()
      .optionallyWith(
        trialSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trialSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListTrialsResponse.wrap(buildAwsValue())
}
object ListTrialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTrialsResponse =
      zio.aws.sagemaker.model.ListTrialsResponse(
        trialSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def trialSummaries
        : Option[List[zio.aws.sagemaker.model.TrialSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTrialSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("trialSummaries", trialSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse
  ) extends zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly {
    override val trialSummaries
        : Option[List[zio.aws.sagemaker.model.TrialSummary.ReadOnly]] = scala
      .Option(impl.trialSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse
  ): zio.aws.sagemaker.model.ListTrialsResponse.ReadOnly = new Wrapper(impl)
}
