package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NotebookInstanceLifecycleConfigNameContains,
  NextToken,
  LastModifiedTime,
  MaxResults
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNotebookInstanceLifecycleConfigsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    sortBy: Option[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = None,
    sortOrder: Option[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = None,
    nameContains: Option[NotebookInstanceLifecycleConfigNameContains] = None,
    creationTimeBefore: Option[CreationTime] = None,
    creationTimeAfter: Option[CreationTime] = None,
    lastModifiedTimeBefore: Option[LastModifiedTime] = None,
    lastModifiedTimeAfter: Option[LastModifiedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest = {
    import ListNotebookInstanceLifecycleConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value =>
          NotebookInstanceLifecycleConfigNameContains.unwrap(
            value
          ): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
      .wrap(buildAwsValue())
}
object ListNotebookInstanceLifecycleConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest =
      zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def sortBy
        : Option[zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey]
    def sortOrder: Option[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ]
    def nameContains: Option[NotebookInstanceLifecycleConfigNameContains]
    def creationTimeBefore: Option[CreationTime]
    def creationTimeAfter: Option[CreationTime]
    def lastModifiedTimeBefore: Option[LastModifiedTime]
    def lastModifiedTimeAfter: Option[LastModifiedTime]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ) extends zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortBy: Option[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
    ] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortKey
          .wrap(value)
      )
    override val sortOrder: Option[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
    ] = scala
      .Option(impl.sortOrder())
      .map(value =>
        zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSortOrder
          .wrap(value)
      )
    override val nameContains
        : Option[NotebookInstanceLifecycleConfigNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigNameContains(value)
      )
    override val creationTimeBefore: Option[CreationTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeAfter: Option[CreationTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeBefore: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val lastModifiedTimeAfter: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest
  ): zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
