package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  EndpointNameContains,
  MaxResults,
  PaginationToken
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEndpointsRequest(
    sortBy: Option[zio.aws.sagemaker.model.EndpointSortKey] = None,
    sortOrder: Option[zio.aws.sagemaker.model.OrderKey] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None,
    nameContains: Option[EndpointNameContains] = None,
    creationTimeBefore: Option[Timestamp] = None,
    creationTimeAfter: Option[Timestamp] = None,
    lastModifiedTimeBefore: Option[Timestamp] = None,
    lastModifiedTimeAfter: Option[Timestamp] = None,
    statusEquals: Option[zio.aws.sagemaker.model.EndpointStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest = {
    import ListEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          EndpointNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListEndpointsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListEndpointsRequest.wrap(buildAwsValue())
}
object ListEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEndpointsRequest =
      zio.aws.sagemaker.model.ListEndpointsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        statusEquals.map(value => value)
      )
    def sortBy: Option[zio.aws.sagemaker.model.EndpointSortKey]
    def sortOrder: Option[zio.aws.sagemaker.model.OrderKey]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def nameContains: Option[EndpointNameContains]
    def creationTimeBefore: Option[Timestamp]
    def creationTimeAfter: Option[Timestamp]
    def lastModifiedTimeBefore: Option[Timestamp]
    def lastModifiedTimeAfter: Option[Timestamp]
    def statusEquals: Option[zio.aws.sagemaker.model.EndpointStatus]
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.OrderKey] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, EndpointNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest
  ) extends zio.aws.sagemaker.model.ListEndpointsRequest.ReadOnly {
    override val sortBy: Option[zio.aws.sagemaker.model.EndpointSortKey] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.EndpointSortKey.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.OrderKey] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.OrderKey.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Option[EndpointNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.EndpointNameContains(value)
      )
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val statusEquals: Option[zio.aws.sagemaker.model.EndpointStatus] =
      scala
        .Option(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.EndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest
  ): zio.aws.sagemaker.model.ListEndpointsRequest.ReadOnly = new Wrapper(impl)
}
