package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.SnsTopicArn
import scala.jdk.CollectionConverters._
final case class LabelingJobSnsDataSource(snsTopicArn: SnsTopicArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource = {
    import LabelingJobSnsDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource
      .builder()
      .snsTopicArn(SnsTopicArn.unwrap(snsTopicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobSnsDataSource.wrap(buildAwsValue())
}
object LabelingJobSnsDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobSnsDataSource =
      zio.aws.sagemaker.model.LabelingJobSnsDataSource(snsTopicArn)
    def snsTopicArn: SnsTopicArn
    def getSnsTopicArn: ZIO[Any, Nothing, SnsTopicArn] =
      ZIO.succeed(snsTopicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource
  ) extends zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly {
    override val snsTopicArn: SnsTopicArn =
      zio.aws.sagemaker.model.primitives.SnsTopicArn(impl.snsTopicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobSnsDataSource
  ): zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly = new Wrapper(
    impl
  )
}
