package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, EdgeVersion, EntityName}
import scala.jdk.CollectionConverters._
final case class EdgeModel(
    modelName: EntityName,
    modelVersion: EdgeVersion,
    latestSampleTime: Option[Timestamp] = None,
    latestInference: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeModel = {
    import EdgeModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeModel
      .builder()
      .modelName(EntityName.unwrap(modelName): java.lang.String)
      .modelVersion(EdgeVersion.unwrap(modelVersion): java.lang.String)
      .optionallyWith(
        latestSampleTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestSampleTime)
      .optionallyWith(
        latestInference.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestInference)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeModel.ReadOnly =
    zio.aws.sagemaker.model.EdgeModel.wrap(buildAwsValue())
}
object EdgeModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeModel =
      zio.aws.sagemaker.model.EdgeModel(
        modelName,
        modelVersion,
        latestSampleTime.map(value => value),
        latestInference.map(value => value)
      )
    def modelName: EntityName
    def modelVersion: EdgeVersion
    def latestSampleTime: Option[Timestamp]
    def latestInference: Option[Timestamp]
    def getModelName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(modelName)
    def getModelVersion: ZIO[Any, Nothing, EdgeVersion] =
      ZIO.succeed(modelVersion)
    def getLatestSampleTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestSampleTime", latestSampleTime)
    def getLatestInference: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestInference", latestInference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModel
  ) extends zio.aws.sagemaker.model.EdgeModel.ReadOnly {
    override val modelName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelName())
    override val modelVersion: EdgeVersion =
      zio.aws.sagemaker.model.primitives.EdgeVersion(impl.modelVersion())
    override val latestSampleTime: Option[Timestamp] = scala
      .Option(impl.latestSampleTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val latestInference: Option[Timestamp] = scala
      .Option(impl.latestInference())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeModel
  ): zio.aws.sagemaker.model.EdgeModel.ReadOnly = new Wrapper(impl)
}
