package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DriftCheckModelQuality(
    statistics: Option[zio.aws.sagemaker.model.MetricsSource] = None,
    constraints: Option[zio.aws.sagemaker.model.MetricsSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality = {
    import DriftCheckModelQuality.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality
      .builder()
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckModelQuality.wrap(buildAwsValue())
}
object DriftCheckModelQuality {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckModelQuality =
      zio.aws.sagemaker.model.DriftCheckModelQuality(
        statistics.map(value => value.asEditable),
        constraints.map(value => value.asEditable)
      )
    def statistics: Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def constraints: Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality
  ) extends zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly {
    override val statistics
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.statistics())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val constraints
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.constraints())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality
  ): zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly = new Wrapper(impl)
}
