package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  LastModifiedTime,
  NotebookInstanceLifecycleConfigName,
  NotebookInstanceLifecycleConfigArn
}
import scala.jdk.CollectionConverters._
final case class DescribeNotebookInstanceLifecycleConfigResponse(
    notebookInstanceLifecycleConfigArn: Option[
      NotebookInstanceLifecycleConfigArn
    ] = None,
    notebookInstanceLifecycleConfigName: Option[
      NotebookInstanceLifecycleConfigName
    ] = None,
    onCreate: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = None,
    onStart: Option[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
    ] = None,
    lastModifiedTime: Option[LastModifiedTime] = None,
    creationTime: Option[CreationTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse = {
    import DescribeNotebookInstanceLifecycleConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
      .builder()
      .optionallyWith(
        notebookInstanceLifecycleConfigArn.map(value =>
          NotebookInstanceLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigArn)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(
        onCreate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onCreate)
      .optionallyWith(
        onStart.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onStart)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceLifecycleConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse =
      zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse(
        notebookInstanceLifecycleConfigArn.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        onCreate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onStart.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value)
      )
    def notebookInstanceLifecycleConfigArn
        : Option[NotebookInstanceLifecycleConfigArn]
    def notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName]
    def onCreate: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def onStart: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ]
    def lastModifiedTime: Option[LastModifiedTime]
    def creationTime: Option[CreationTime]
    def getNotebookInstanceLifecycleConfigArn
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigArn] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigArn",
        notebookInstanceLifecycleConfigArn
      )
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getOnCreate: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onCreate", onCreate)
    def getOnStart: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly
    ]] = AwsError.unwrapOptionField("onStart", onStart)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly {
    override val notebookInstanceLifecycleConfigArn
        : Option[NotebookInstanceLifecycleConfigArn] = scala
      .Option(impl.notebookInstanceLifecycleConfigArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigArn(value)
      )
    override val notebookInstanceLifecycleConfigName
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val onCreate: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = scala
      .Option(impl.onCreate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val onStart: Option[
      List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly]
    ] = scala
      .Option(impl.onStart())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(item)
        }.toList
      )
    override val lastModifiedTime: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse.ReadOnly =
    new Wrapper(impl)
}
