package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  Timestamp,
  MonitoringJobDefinitionName,
  MonitoringJobDefinitionArn
}
import scala.jdk.CollectionConverters._
final case class DescribeModelExplainabilityJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn,
    jobDefinitionName: MonitoringJobDefinitionName,
    creationTime: Timestamp,
    modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig
    ] = None,
    modelExplainabilityAppSpecification: zio.aws.sagemaker.model.ModelExplainabilityAppSpecification,
    modelExplainabilityJobInput: zio.aws.sagemaker.model.ModelExplainabilityJobInput,
    modelExplainabilityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse = {
    import DescribeModelExplainabilityJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        modelExplainabilityBaselineConfig.map(value => value.buildAwsValue())
      )(_.modelExplainabilityBaselineConfig)
      .modelExplainabilityAppSpecification(
        modelExplainabilityAppSpecification.buildAwsValue()
      )
      .modelExplainabilityJobInput(modelExplainabilityJobInput.buildAwsValue())
      .modelExplainabilityJobOutputConfig(
        modelExplainabilityJobOutputConfig.buildAwsValue()
      )
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
      .wrap(buildAwsValue())
}
object DescribeModelExplainabilityJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse =
      zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse(
        jobDefinitionArn,
        jobDefinitionName,
        creationTime,
        modelExplainabilityBaselineConfig.map(value => value.asEditable),
        modelExplainabilityAppSpecification.asEditable,
        modelExplainabilityJobInput.asEditable,
        modelExplainabilityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable)
      )
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def jobDefinitionName: MonitoringJobDefinitionName
    def creationTime: Timestamp
    def modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ]
    def modelExplainabilityAppSpecification
        : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly
    def modelExplainabilityJobInput
        : zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly
    def modelExplainabilityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getModelExplainabilityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelExplainabilityBaselineConfig",
      modelExplainabilityBaselineConfig
    )
    def getModelExplainabilityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly
    ] = ZIO.succeed(modelExplainabilityAppSpecification)
    def getModelExplainabilityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly
    ] = ZIO.succeed(modelExplainabilityJobInput)
    def getModelExplainabilityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(modelExplainabilityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ] = scala
      .Option(impl.modelExplainabilityBaselineConfig())
      .map(value =>
        zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.wrap(value)
      )
    override val modelExplainabilityAppSpecification
        : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.ModelExplainabilityAppSpecification
        .wrap(impl.modelExplainabilityAppSpecification())
    override val modelExplainabilityJobInput
        : zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly =
      zio.aws.sagemaker.model.ModelExplainabilityJobInput
        .wrap(impl.modelExplainabilityJobInput())
    override val modelExplainabilityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.modelExplainabilityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse
  ): zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
