package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ImageVersionNumber, ImageName}
import scala.jdk.CollectionConverters._
final case class DescribeImageVersionRequest(
    imageName: ImageName,
    version: Option[ImageVersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest = {
    import DescribeImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageVersionRequest.wrap(buildAwsValue())
}
object DescribeImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageVersionRequest =
      zio.aws.sagemaker.model
        .DescribeImageVersionRequest(imageName, version.map(value => value))
    def imageName: ImageName
    def version: Option[ImageVersionNumber]
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ) extends zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val version: Option[ImageVersionNumber] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest
  ): zio.aws.sagemaker.model.DescribeImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
