package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  RoleArn,
  InferenceImage,
  Timestamp,
  FailureReason,
  CompilationJobArn,
  LastModifiedTime,
  ModelPackageArn,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class DescribeCompilationJobResponse(
    compilationJobName: EntityName,
    compilationJobArn: CompilationJobArn,
    compilationJobStatus: zio.aws.sagemaker.model.CompilationJobStatus,
    compilationStartTime: Option[Timestamp] = None,
    compilationEndTime: Option[Timestamp] = None,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    inferenceImage: Option[InferenceImage] = None,
    modelPackageVersionArn: Option[ModelPackageArn] = None,
    creationTime: CreationTime,
    lastModifiedTime: LastModifiedTime,
    failureReason: FailureReason,
    modelArtifacts: zio.aws.sagemaker.model.ModelArtifacts,
    modelDigests: Option[zio.aws.sagemaker.model.ModelDigests] = None,
    roleArn: RoleArn,
    inputConfig: zio.aws.sagemaker.model.InputConfig,
    outputConfig: zio.aws.sagemaker.model.OutputConfig,
    vpcConfig: Option[zio.aws.sagemaker.model.NeoVpcConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse = {
    import DescribeCompilationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse
      .builder()
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .compilationJobArn(
        CompilationJobArn.unwrap(compilationJobArn): java.lang.String
      )
      .compilationJobStatus(compilationJobStatus.unwrap)
      .optionallyWith(
        compilationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.compilationStartTime)
      .optionallyWith(
        compilationEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.compilationEndTime)
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .optionallyWith(
        inferenceImage.map(value =>
          InferenceImage.unwrap(value): java.lang.String
        )
      )(_.inferenceImage)
      .optionallyWith(
        modelPackageVersionArn.map(value =>
          ModelPackageArn.unwrap(value): java.lang.String
        )
      )(_.modelPackageVersionArn)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .lastModifiedTime(LastModifiedTime.unwrap(lastModifiedTime): Instant)
      .failureReason(FailureReason.unwrap(failureReason): java.lang.String)
      .modelArtifacts(modelArtifacts.buildAwsValue())
      .optionallyWith(modelDigests.map(value => value.buildAwsValue()))(
        _.modelDigests
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .inputConfig(inputConfig.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeCompilationJobResponse.wrap(buildAwsValue())
}
object DescribeCompilationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeCompilationJobResponse =
      zio.aws.sagemaker.model.DescribeCompilationJobResponse(
        compilationJobName,
        compilationJobArn,
        compilationJobStatus,
        compilationStartTime.map(value => value),
        compilationEndTime.map(value => value),
        stoppingCondition.asEditable,
        inferenceImage.map(value => value),
        modelPackageVersionArn.map(value => value),
        creationTime,
        lastModifiedTime,
        failureReason,
        modelArtifacts.asEditable,
        modelDigests.map(value => value.asEditable),
        roleArn,
        inputConfig.asEditable,
        outputConfig.asEditable,
        vpcConfig.map(value => value.asEditable)
      )
    def compilationJobName: EntityName
    def compilationJobArn: CompilationJobArn
    def compilationJobStatus: zio.aws.sagemaker.model.CompilationJobStatus
    def compilationStartTime: Option[Timestamp]
    def compilationEndTime: Option[Timestamp]
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def inferenceImage: Option[InferenceImage]
    def modelPackageVersionArn: Option[ModelPackageArn]
    def creationTime: CreationTime
    def lastModifiedTime: LastModifiedTime
    def failureReason: FailureReason
    def modelArtifacts: zio.aws.sagemaker.model.ModelArtifacts.ReadOnly
    def modelDigests: Option[zio.aws.sagemaker.model.ModelDigests.ReadOnly]
    def roleArn: RoleArn
    def inputConfig: zio.aws.sagemaker.model.InputConfig.ReadOnly
    def outputConfig: zio.aws.sagemaker.model.OutputConfig.ReadOnly
    def vpcConfig: Option[zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly]
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
    def getCompilationJobArn: ZIO[Any, Nothing, CompilationJobArn] =
      ZIO.succeed(compilationJobArn)
    def getCompilationJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CompilationJobStatus] =
      ZIO.succeed(compilationJobStatus)
    def getCompilationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("compilationStartTime", compilationStartTime)
    def getCompilationEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("compilationEndTime", compilationEndTime)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getInferenceImage: ZIO[Any, AwsError, InferenceImage] =
      AwsError.unwrapOptionField("inferenceImage", inferenceImage)
    def getModelPackageVersionArn: ZIO[Any, AwsError, ModelPackageArn] =
      AwsError.unwrapOptionField(
        "modelPackageVersionArn",
        modelPackageVersionArn
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, LastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, Nothing, FailureReason] =
      ZIO.succeed(failureReason)
    def getModelArtifacts
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelArtifacts.ReadOnly] =
      ZIO.succeed(modelArtifacts)
    def getModelDigests
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelDigests.ReadOnly] =
      AwsError.unwrapOptionField("modelDigests", modelDigests)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getInputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InputConfig.ReadOnly] =
      ZIO.succeed(inputConfig)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse
  ) extends zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly {
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
    override val compilationJobArn: CompilationJobArn =
      zio.aws.sagemaker.model.primitives
        .CompilationJobArn(impl.compilationJobArn())
    override val compilationJobStatus
        : zio.aws.sagemaker.model.CompilationJobStatus =
      zio.aws.sagemaker.model.CompilationJobStatus
        .wrap(impl.compilationJobStatus())
    override val compilationStartTime: Option[Timestamp] = scala
      .Option(impl.compilationStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val compilationEndTime: Option[Timestamp] = scala
      .Option(impl.compilationEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val inferenceImage: Option[InferenceImage] = scala
      .Option(impl.inferenceImage())
      .map(value => zio.aws.sagemaker.model.primitives.InferenceImage(value))
    override val modelPackageVersionArn: Option[ModelPackageArn] = scala
      .Option(impl.modelPackageVersionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelPackageArn(value))
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val lastModifiedTime: LastModifiedTime =
      zio.aws.sagemaker.model.primitives
        .LastModifiedTime(impl.lastModifiedTime())
    override val failureReason: FailureReason =
      zio.aws.sagemaker.model.primitives.FailureReason(impl.failureReason())
    override val modelArtifacts
        : zio.aws.sagemaker.model.ModelArtifacts.ReadOnly =
      zio.aws.sagemaker.model.ModelArtifacts.wrap(impl.modelArtifacts())
    override val modelDigests
        : Option[zio.aws.sagemaker.model.ModelDigests.ReadOnly] = scala
      .Option(impl.modelDigests())
      .map(value => zio.aws.sagemaker.model.ModelDigests.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val inputConfig: zio.aws.sagemaker.model.InputConfig.ReadOnly =
      zio.aws.sagemaker.model.InputConfig.wrap(impl.inputConfig())
    override val outputConfig: zio.aws.sagemaker.model.OutputConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputConfig.wrap(impl.outputConfig())
    override val vpcConfig
        : Option[zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.sagemaker.model.NeoVpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse
  ): zio.aws.sagemaker.model.DescribeCompilationJobResponse.ReadOnly =
    new Wrapper(impl)
}
