package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters._
final case class DeleteArtifactResponse(
    artifactArn: Option[ArtifactArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse = {
    import DeleteArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteArtifactResponse.wrap(buildAwsValue())
}
object DeleteArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteArtifactResponse =
      zio.aws.sagemaker.model
        .DeleteArtifactResponse(artifactArn.map(value => value))
    def artifactArn: Option[ArtifactArn]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ) extends zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly {
    override val artifactArn: Option[ArtifactArn] = scala
      .Option(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse
  ): zio.aws.sagemaker.model.DeleteArtifactResponse.ReadOnly = new Wrapper(impl)
}
