package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  String256,
  SingleSignOnUserIdentifier,
  UserProfileName,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class CreateUserProfileRequest(
    domainId: DomainId,
    userProfileName: UserProfileName,
    singleSignOnUserIdentifier: Option[SingleSignOnUserIdentifier] = None,
    singleSignOnUserValue: Option[String256] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    userSettings: Option[zio.aws.sagemaker.model.UserSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest = {
    import CreateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .optionallyWith(
        singleSignOnUserIdentifier.map(value =>
          SingleSignOnUserIdentifier.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserIdentifier)
      .optionallyWith(
        singleSignOnUserValue.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.singleSignOnUserValue)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(userSettings.map(value => value.buildAwsValue()))(
        _.userSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateUserProfileRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateUserProfileRequest.wrap(buildAwsValue())
}
object CreateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateUserProfileRequest =
      zio.aws.sagemaker.model.CreateUserProfileRequest(
        domainId,
        userProfileName,
        singleSignOnUserIdentifier.map(value => value),
        singleSignOnUserValue.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userSettings.map(value => value.asEditable)
      )
    def domainId: DomainId
    def userProfileName: UserProfileName
    def singleSignOnUserIdentifier: Option[SingleSignOnUserIdentifier]
    def singleSignOnUserValue: Option[String256]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def userSettings: Option[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
    def getSingleSignOnUserIdentifier
        : ZIO[Any, AwsError, SingleSignOnUserIdentifier] =
      AwsError.unwrapOptionField(
        "singleSignOnUserIdentifier",
        singleSignOnUserIdentifier
      )
    def getSingleSignOnUserValue: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("singleSignOnUserValue", singleSignOnUserValue)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest
  ) extends zio.aws.sagemaker.model.CreateUserProfileRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
    override val singleSignOnUserIdentifier
        : Option[SingleSignOnUserIdentifier] = scala
      .Option(impl.singleSignOnUserIdentifier())
      .map(value =>
        zio.aws.sagemaker.model.primitives.SingleSignOnUserIdentifier(value)
      )
    override val singleSignOnUserValue: Option[String256] = scala
      .Option(impl.singleSignOnUserValue())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val userSettings
        : Option[zio.aws.sagemaker.model.UserSettings.ReadOnly] = scala
      .Option(impl.userSettings())
      .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest
  ): zio.aws.sagemaker.model.CreateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
