package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{EntityDescription, EntityName}
import scala.jdk.CollectionConverters._
final case class CreateModelPackageGroupRequest(
    modelPackageGroupName: EntityName,
    modelPackageGroupDescription: Option[EntityDescription] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest = {
    import CreateModelPackageGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .optionallyWith(
        modelPackageGroupDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageGroupRequest.wrap(buildAwsValue())
}
object CreateModelPackageGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageGroupRequest =
      zio.aws.sagemaker.model.CreateModelPackageGroupRequest(
        modelPackageGroupName,
        modelPackageGroupDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageGroupName: EntityName
    def modelPackageGroupDescription: Option[EntityDescription]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
    def getModelPackageGroupDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageGroupDescription",
        modelPackageGroupDescription
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ) extends zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
    override val modelPackageGroupDescription: Option[EntityDescription] = scala
      .Option(impl.modelPackageGroupDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ): zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly =
    new Wrapper(impl)
}
